﻿$(function () {
    debugger;
    //Define the Global Variables across functions.
    var bingMapsKey = 'AnMPbAuzGgURbEiN9H96j4mBiJo-JPk4fqMtkmfc6NEet28pqceuyiqk_kWrFD6x';
    var map, locs, pins, listItems, infobox, searchManager, orgUrl, webAPIUrl, searchLocation, searchLocality, userQueryId, fetchXmlEncoded;
    var specialtySearch = new String();
    var taxonomies = new Array();
    var networkAffiliations = new Array();
    
    //We will load the map and other fucntions once the HTML page has finished loading. 
    document.onreadystatechange = function () {
        if (document.readyState == "complete") {
            startMap();
        }
    }

    function startMap() {

        // Load the map.
        map = new Microsoft.Maps.Map(document.getElementById('myMap'),
            {
                credentials: bingMapsKey,
                //center: new Microsoft.Maps.Location(38.890369, -77.031960),
                mapTypeId: Microsoft.Maps.MapTypeId.road,
                zoom: 12
            });

        // A setting for specifying the distance units displayed. Possible values are 'km' and 'mi'.
        var distanceUnits = 'mi';

        orgUrl = window.parent.Xrm.Page.context.getClientUrl();
        webAPIUrl = orgUrl + "/api/data/v8.2/";

        // Create a global infobox control.
        infobox = new Microsoft.Maps.Infobox(new Microsoft.Maps.Location(0, 0),
            {
                visible: false,
                offset: new Microsoft.Maps.Point(0, 20),
                height: 230,
                width: 230
            });

        infobox.setMap(map);

        // Create a session key from the map to use with data source service requests.
        var sessionKey;
        map.getCredentials(function (c) {
            sessionKey = c;
        });

        Microsoft.Maps.loadModule('Microsoft.Maps.Clustering');

        // Load the Search Module for Bing Maps for doing geocoding.
        Microsoft.Maps.loadModule('Microsoft.Maps.Search',
            {
                callback: function () {
                    searchManager = new Microsoft.Maps.Search.SearchManager(map);
                }
            });

        Microsoft.Maps.loadModule('Microsoft.Maps.AutoSuggest', function () {
            var suggestOptions = {
                addressSuggestions: true,
                autoDetectLocation: true,
                placeSuggestions: true,
                maxResults: 4,
                map: map
            };
            var manager = new Microsoft.Maps.AutosuggestManager(suggestOptions);
            manager.attachAutosuggest('#searchBox', '#searchSuggestion');
        });

        // Resize the height of the results panel based on the available space.

        $(window).resize(function () {
            $('.resultsPanel').height($(window).height() - $('.searchBar').height() - 360);
            $('.mapPanel').height($(window).height() - 360);
            $('.sidePanel').height($(window).height() - 360);
        });
        $(window).resize();


        // A simple function for displaying error messages in the app.
        function showErrorMsg(msg) {
            $('.resultsPanel').html('<span class="alert alert-danger">' + msg + '</span>');
        }

        // A simple function for clearing the map and results panel.
        function clearMapAndResultsPanel() {

            map.layers.clear();
            infobox.setOptions({ visible: false });
            $('.resultsPanel').html('');
            document.getElementById('loaderTitle').style.display = 'none';
            document.getElementById('loader').style.display = 'none';
            document.getElementById('resultsPanel').style.display = 'none';
            locs = [];
            pins = [];
            listItems = [];
        }

        // Formats a time in 1000 hours to hh:mm AM/PM format
        function formatTime(val) {
            var minutes = val % 100;
            var hours = Math.round(val / 100);

            if (minutes == 0) {
                minutes = '00';
            }

            if (hours > 12) {
                return (hours - 12) + ':' + minutes + 'PM';
            } else {
                return hours + ':' + minutes + 'AM';
            }
        }

        // Calculates the shortest distance between two locations on the curvature of the earth.
        function haversineDistance(loc1, loc2) {
            var degToRad = Math.PI / 180,
                lat1 = loc1.latitude * degToRad,
                lon1 = loc1.longitude * degToRad,
                lat2 = loc2.latitude * degToRad,
                lon2 = loc2.longitude * degToRad;

            var dLat = lat2 - lat1,
                dLon = lon2 - lon1,
                cordLength = Math.pow(Math.sin(dLat / 2), 2) +
                    Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dLon / 2), 2),
                centralAngle = 2 * Math.atan2(Math.sqrt(cordLength), Math.sqrt(1 - cordLength));

            var earthRadius = (distanceUnits == 'km') ? 6378.1 : 3963.1676;
            var distance = earthRadius * centralAngle;

            // Round off distance to 2 decimal place
            return Math.round(distance * 100) / 100;
        }

        // Add a key press event to the search box that triggers the search when the user presses Enter key.
        $('#specialtySearchBox').keypress(function (e) {
            if (e.which == 13) {
                $('#specialtySearchButton').click();
            }
        });

        // Add a click event to the search button.
        $('#specialtySearchButton').click(function () {
            //$('#specialtySearchBox')[0].value = "";
            specialtySearch = $('#specialtySearchBox')[0].value;
            taxonomies = [];
            var objectTypeCode = "";
            if (Mscrm.XrmInternal.getEntityCode != null && Mscrm.XrmInternal.getEntityCode != undefined)
                objectTypeCode = Mscrm.XrmInternal.getEntityCode("ppms_taxonomy");
            else
                objectTypeCode = Mscrm.XrmInternal.prototype.getEntityCode("ppms_taxonomy");

            var DialogOptions = new window.parent.Xrm.DialogOptions();
            DialogOptions.width = 800;
            DialogOptions.height = 600;

            var url = orgUrl + "/_controls/lookup/lookupmulti.aspx?class=null&objecttypes=" + objectTypeCode + "&browse=0&ShowNewButton=0&ShowPropButton=1&DefaultType=0" + "&search=" + specialtySearch;

            window.parent.Xrm.Internal.openDialog(url, DialogOptions, null, null, CallbackFunction);

            function CallbackFunction(event) {
                if (event.items.length != 0) {
                    var specialties = event.items;
                    var name = new String();

                    //Check for how many Specialties have been selected. 
                    /*
                    if (specialties.length > 20) {
                        document.getElementById('loaderTitle').style.display = 'none';
                        document.getElementById('loader').style.display = 'none';
                        document.getElementById('resultsPanel').style.display = 'block';
                        showErrorMsg('A maximum of 20 specialties can be selected for search.');

                    }
                    */

                    for (var s = 0; s < specialties.length; s++) {
                        name += event.items[s].name;
                        var taxonomyId = event.items[s].id.replace(/[{}]/g, "");
                        taxonomies.push(taxonomyId);
                        if (s != specialties.length - 1) { name += ", " };
                    }
                    $('#specialtySearchBox')[0].value = name;
                    specialtySearch = $('#specialtySearchBox')[0].value;
                }
            }
        });

        // Add a key press event to the search box that triggers the search when the user presses Enter key.
        $('#searchBox').keypress(function (e) {
            if (e.which == 13) {
                $('#searchBtn').click();
            }
        });

        // Add a click event to the search button.
        $('#searchBtn').click(function () {
            clearMapAndResultsPanel();
            document.getElementById('loaderTitle').style.display = 'block';
            document.getElementById('loader').style.display = 'block';
            //Filtering Options
            //Each time the Search Button is clicked we will recheck the Criteria selected by user.           
            //Reset the Provider Details each time. 
            var male = false;
            var female = false;
            var primarycare = false;
            var acceptingnew = false;
            //Clear out the networkAffiliations Array each time. 
            networkAffiliations = [];
            if ($.inArray("male", $('#e2').val()) != -1) {male = true;}
            if ($.inArray("female", $('#e2').val()) != -1) {female = true;}
            if ($.inArray("primarycare", $('#e2').val()) != -1) {primarycare = true;}
            if ($.inArray("acceptingnew", $('#e2').val()) != -1) { acceptingnew = true; }
            if ($.inArray("choice", $('#e3').val()) != -1) { networkAffiliations.push('78318F9D-385C-E711-81C7-1458D04E1B18'); }
            if ($.inArray("healthnet", $('#e3').val()) != -1) { networkAffiliations.push('A32D19C6-F7BB-E611-8100-1458D04E8FF8');}
            if ($.inArray("nppes", $('#e3').val()) != -1) { networkAffiliations.push('EFFDB3F9-866D-E711-810C-1458D04EF938');}
            if ($.inArray("nuncehgregion2", $('#e3').val()) != -1) { networkAffiliations.push('701BA922-9FC3-E611-8112-1458D04ECFB0');}
            if ($.inArray("nuncehgregion3", $('#e3').val()) != -1) { networkAffiliations.push('069BF129-49D4-E611-8115-1458D04ECFB0');}
            if ($.inArray("provideragreement", $('#e3').val()) != -1) { networkAffiliations.push('2AB01B0B-864C-E711-810B-1458D04D2538');}
            if ($.inArray("triwest", $('#e3').val()) != -1) { networkAffiliations.push('9A23DDBF-F6BB-E611-8100-1458D04E8FF8');}

            //Check for a value in the the Specialty Search box. 
            specialtySearch = $('#specialtySearchBox')[0].value;

            //Check for a value in the Search Location Box. If empty give the user a message. 
            if ($('#searchBox').val() == null) {
                document.getElementById('loaderTitle').style.display = 'none';
                document.getElementById('loader').style.display = 'none';
                document.getElementById('resultsPanel').style.display = 'block';
                showErrorMsg('Address search location can not be empty.');
            }

            geocodeRequest();

            function geocodeRequest() {
                // Create a request to geocode the users search.
                var geocodeRequest = {
                    where: $('#searchBox').val(),
                    count: 1,
                    callback: function (r) {
                        if (r &&
                            r.results &&
                            r.results.length > 0 &&
                            r.results[0].location) {
                            searchLocation = r.results[0].location;
                            searchLocality = r.results[0].address.adminDistrict;
                            buildFetchXml();
                        } else {
                            document.getElementById('loaderTitle').style.display = 'none';
                            document.getElementById('loader').style.display = 'none';
                            document.getElementById('resultsPanel').style.display = 'block';
                            showErrorMsg('Unable to locate the given address.');
                        }
                    },
                    errorCallback: function () {
                        document.getElementById('loaderTitle').style.display = 'none';
                        document.getElementById('loader').style.display = 'none';
                        document.getElementById('resultsPanel').style.display = 'block';
                        showErrorMsg('Please enter a valid address into the search box.');
                    }
                };

                // Geocode the users search.
                searchManager.geocode(geocodeRequest);
            }

            function buildFetchXml() {

                //Build the FetchXml here for the savedview. 
                var fetchXml = new String();
                fetchXml =
                    '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="true">' +
                    '<entity name="ppms_providerservice">' +
                    '<attribute name="ppms_name"/>' +
                    '<attribute name="ppms_caresiteaddress" />' +
                    '<attribute name="ppms_caresitecity" />' +
                    '<attribute name="ppms_caresitestateprovince" />' +
                    '<attribute name="ppms_caresitezipcode" />' +
                    '<attribute name="ppms_caresiteaddresslatitude" />' +
                    '<attribute name="ppms_caresiteaddresslongitude" />' +
                    '<attribute name="ppms_specialtynametext" />' +
                    '<attribute name="ppms_providername" />' +
                    '<attribute name="ppms_providerid" />' +
                    '<attribute name="ppms_providerserviceid" />' +
                    '<order attribute="ppms_name" descending="false" />' +
                    '<filter type="and">' +
                    '<condition attribute="statecode" operator="eq" value="0" />' +
                    '<condition attribute="ppms_geocoded" operator="eq" value="1" />';
                    
                //Network Affiliations
                if (networkAffiliations.length > 1) { fetchXml += '<filter type="or">'; };
                for (var n = 0; n < networkAffiliations.length; n++) {
                    var networkId = networkAffiliations[n];
                        fetchXml +=
                            '<condition attribute="ppms_network" operator="eq" uiname="" uitype="ppms_vaprovidernetwork" value="{' + networkId + '}" />';
                    };
                    if (networkAffiliations.length > 1) { fetchXml += '</filter>'; };
                
                //Specialties
                if (!!specialtySearch && !!taxonomies) {
                    if (taxonomies.length > 1) { fetchXml += '<filter type="or">'; };
                    for (var t = 0; t < taxonomies.length; t++) {
                        var taxonomyId = taxonomies[t];
                        fetchXml +=
                            '<condition attribute="ppms_specialty" operator="eq" uiname="" uitype="ppms_taxonomy" value="{' + taxonomyId + '}" />';
                    };
                    if (taxonomies.length > 1) { fetchXml += '</filter>'; };
                }
                fetchXml += '</filter>';

                //Add the filtering attributes from Provider (link entity)
                fetchXml += '<link-entity name="account" alias="am" to="ppms_providerid" from="accountid" ><filter type="and">';

                //Provider Specific Filter Criteria: 
                //Check Gender if one of the genders is unchecked, we will search based on the selected gender. 
                if (!male || !female) {
                    if (male) { fetchXml += '<condition attribute="ppms_gender" operator="eq" value="767940002" />' }
                    if (female) { fetchXml += '<condition attribute="ppms_gender" operator="eq" value="767940001" />' }
                };
                //Check if Primary Care Physician
                if (primarycare) { fetchXml += '<condition attribute="ppms_primarycarephysician" operator="eq" value="1" />' };
                //Check for Accepting New Patients
                if (acceptingnew) { fetchXml += '<condition attribute="ppms_individualisacceptingnewpatients" operator="eq" value="1" />' };
                //Check Primary Care is accepting VA 
                if (acceptingnew) { fetchXml += '<condition attribute="ppms_primarycareprovideracceptingva" operator="eq" value="1" />' };
                fetchXml += '</filter></link-entity></entity></fetch>';
                fetchXmlEncoded = escape(fetchXml);

                findProviders();
            }


        });


        function findProviders() {

            //Generate a Request URL with options to Query CRM Web API data. 
            var number = 25;
            var request = new String();

            //var requestType = "accounts?userQuery=";
            //request += webAPIUrl + requestType + userQueryId;

            var requestType = "ppms_providerservices?fetchXml=";
            request += webAPIUrl + requestType + fetchXmlEncoded;

            $.ajax({
                type: "GET",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: request,
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {
                    filterProviders(data, textStatus, xhr);
                    //Only doing this if we ended up Creating a User Query. 
                    //cleanUpUserQuery();
                },
                error: function (e) {
                    document.getElementById('loaderTitle').style.display = 'none';
                    document.getElementById('loader').style.display = 'none';
                    document.getElementById('resultsPanel').style.display = 'block';
                    showErrorMsg(e.statusText);
                }
            });
        }

        function cleanUpUserQuery() {

            //Delete the userquery that was created. 
            $.ajax({
                type: "DELETE",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: webAPIUrl + "userqueries(" + userQueryId + ")",
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {
                },
                error: function (e) {
                    var error = e;
                }
            });

        }

        function filterProviders(data, textStatus, xhr) {
            var providers = data.value;
            //IF after applying the filters we have Providers, proceed to sorting by distance / radius. 
            //Otherwise display a message to the user. 
            if (providers.length > 0) {
                sortProvidersByDistance(providers);
            } else {
                document.getElementById('loaderTitle').style.display = 'none';
                document.getElementById('loader').style.display = 'none';
                document.getElementById('resultsPanel').style.display = 'block';
                showErrorMsg('No Providers found matching the Search Criteria. Try updating your Search Criteria or Expand your Search Radius.');
            }
        }

        function sortProvidersByDistance(providers) {

            //Filter out the Providers outside of the defined Radius.
            var searchRadius = $('#radiusSelection').find(":selected").val();
            var providersInRadius = providers.filter(function (provider) {
                var distance = haversineDistance(searchLocation,
                    new Microsoft.Maps
                    .Location(provider.ppms_caresiteaddresslatitude, provider.ppms_caresiteaddresslongitude));
                provider.distance = distance;
                return (distance <= searchRadius)
            });

            if (providersInRadius.length > 0) {

                //Sort the New Provider Array by the distance. 
                providersInRadius.sort(function (a, b) { return a['distance'] - b['distance'] });

                //Modify/Compare elements in the array to see if the Providers/Locations/Specialties are distinct (concatenate specialties as neede)
                //If we have no taxomies(no filter), or multiple selected, we will possibly need to combine providers at the same site with their multiple 
                //specialty info. 
                if (taxonomies.length == 0 || taxonomies.length >=2) {
                    for (var p = 0; p < providersInRadius.length; p++) {
                        if (p != providersInRadius.length-1) {
                            if (providersInRadius[p]._ppms_providerid_value === providersInRadius[p + 1]._ppms_providerid_value
                                && providersInRadius[p].ppms_caresiteaddress === providersInRadius[p + 1].ppms_caresiteaddress
                            )
                            {
                                //Concatenate Specialty 
                                providersInRadius[p+1].ppms_specialtynametext = providersInRadius[p+1].ppms_specialtynametext + ', ' + providersInRadius[p].ppms_specialtynametext;
                                //Remove extra Provider Service record.
                                providersInRadius.splice(p, 1);
                                p = p - 1;
                            }
                        }
                    }
                }

                //The Routes Calculation can take at most 25 WayPoints. The way its calculated 12  provider locations + 12x search location. 
                providersInRadius = providersInRadius.slice(0, 12);

                //Define the Route Request URL.
                var distanceUnits = 'mi';
                var wayPoint1Latitude = searchLocation.latitude;
                var wayPoint1Longitude = searchLocation.longitude;
                var wayPoint1 = wayPoint1Latitude + ", " + wayPoint1Longitude;
                var routeRequest = 'https://dev.virtualearth.net/REST/V1/Routes/Driving?'
                var wayPointNum = 0;
                for (var p = 0; p < providersInRadius.length; p++) {
                    routeRequest += '&wp.' + wayPointNum + '=' + encodeURIComponent(wayPoint1);
                    wayPointNum += 1;
                    var wayPointLatitude = providersInRadius[p].ppms_caresiteaddresslatitude;
                    var wayPointLongitude = providersInRadius[p].ppms_caresiteaddresslongitude;
                    var wayPoint = wayPointLatitude + ", " + wayPointLongitude;
                    routeRequest += '&wp.' + wayPointNum + '=' + encodeURIComponent(wayPoint);
                    wayPointNum += 1;
                }
                routeRequest +=
                    '&avoid=minimizeTolls&du=' +
                    encodeURIComponent(distanceUnits) +
                    '&key=' +
                    encodeURIComponent(bingMapsKey);

                CallRouteService(routeRequest,
                    providersInRadius,
                    drivingResultsCallback);
            } else {
                document.getElementById('loaderTitle').style.display = 'none';
                document.getElementById('loader').style.display = 'none';
                document.getElementById('resultsPanel').style.display = 'block';
                showErrorMsg('No Providers found matching the Search Criteria. Try updating your Search Criteria or Expand your Search Radius.');
            }
        }

        function CallRouteService(routeRequest, providersInRadius, callback) {
            $.ajax({
                url: routeRequest,
                dataType: "jsonp",
                jsonp: "jsonp",
                success: function (r) {
                    callback(r, providersInRadius);
                },
                error: function (e) {
                    //alert(e.statusText);
                    alert("Driving Route Error: " + e.statusText)
                }
            });
        }

        function drivingResultsCallback(routeResult, providersInRadius) {
            // Do something with the result
            if (routeResult &&
                routeResult.resourceSets &&
                routeResult.resourceSets.length > 0 &&
                routeResult.resourceSets[0].resources &&
                routeResult.resourceSets[0].resources.length > 0) {
                var travelDistanceSet = routeResult.resourceSets[0];
                var routeLegs = travelDistanceSet.resources[0].routeLegs;
                var routes = new Array();
                for (var r = 0; r < routeLegs.length; r++) {
                    //Only add the Even Route Results to the Routes. 
                    if ((r & 1) == 0) {
                        var routeDrivingDistance = routeLegs[r].travelDistance;
                        routeDrivingDistance = Math.round(routeDrivingDistance * 100) / 100;
                        routes.push(routeDrivingDistance);
                    }
                }
                var providerDrivingDistances = new Array();
                for (var p = 0; p < providersInRadius.length; p++) {
                    providersInRadius[p].drivingDistance = routes[p];
                    providerDrivingDistances.push(providersInRadius[p]);
                }
                //Sorth the New Provider Array by the distance. 
                providerDrivingDistances.sort(function (a, b) { return a['drivingDistance'] - b["drivingDistance"] });
                AddProvidersToMap(providerDrivingDistances);
            }
        }


        function AddProvidersToMap(providerDrivingDistances) {

            //Create an array to store the Provider info passed into function. 
            var providers = providerDrivingDistances;
            //Create an array to store the location metadata. 
            //Moving this above to global variables
            //var locs = [];
            // Create an array to store the HTML used to generate the list of results.
            //Moving this above to global variables
            //var listItems = [];
            //Get the actual address entered in Searchbox for generating directions. The Geocoded searchLocation give's coordinates,
            //which do not work well passed into the Bing Directions URL. 
            var veteranLocation = $('#searchBox').val();

            document.getElementById('loaderTitle').style.display = 'none';
            document.getElementById('loader').style.display = 'none';
            document.getElementById('resultsPanel').style.display = 'block';
            // Create the HTML for a single list item for the result.                        
            //listItems.push('<table class="listItem"><tr><th>Provider Details</th><th>Directions & Distance</th></tr><tr><td rowspan="1"></td>');
            listItems.push('<table class="listItem table table table-hover table-fixed"><thead><tr><th>#</th><th>Provider</th><th>Directions</th><th>Specialty(s)</th></tr></thead><tbody>');
     
            //Loop through the Providers and add them to the map. 
            for (var p = 0; p < providers.length; p++) {
                //Define the Provider's Location for the map. 
                var loc = new Microsoft.Maps
                    .Location(providers[p].ppms_caresiteaddresslatitude, providers[p].ppms_caresiteaddresslongitude);
                // Add the location coordinate to the array of locations
                locs.push(loc);
                // Create pushpin
                var pin = new Microsoft.Maps.Pushpin(loc,
                    {
                        icon: null,
                        text: (locs.length) + ''
                    }
                );
                // Store the location result info as a property of the pushpin so we can use it later.
                pin.Metadata = providers[p];
                // Add a click event to the pushpin to display an infobox.
                Microsoft.Maps.Events.addHandler(pin,
                    'click',
                    function (e) {
                        displayInfobox(e.target);
                    });
                // Add the pushpin to the map.
                //map.entities.push(pin);
                pins.push(pin);

                // Store the result ID as a property of the name. This will allow us to relate the list item to the pushpin on the map.

                //listItems.push('<tbody>');
                listItems.push('<tr>');
                listItems.push('<th scope="row">' + locs.length + '</th>')
                
                listItems
                    .push('<td><a class="title" href="javascript:void(0);" rel="',
                        providers[p].ppms_providerserviceid, '">',
                        providers[p].ppms_providername,
                        '</a><br/>' +
                        providers[p].ppms_caresiteaddress,
                        '<br/>',
                        providers[p].ppms_caresitecity,
                        ', ');
                listItems.push(providers[p].ppms_caresitestateprovince,
                    ' ',
                    providers[p].ppms_caresitezipcode,
                    '<br/>',
                    '<a class="viewprofile" href="javascript:void(0);" rel="',
                    providers[p]._ppms_providerid_value,
                    '">',
                    "View Profile",
                    '</a></td>');
                listItems
                    .push('<td><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                        veteranLocation,
                        '~pos.',
                        pin.Metadata.ppms_caresiteaddresslatitude,
                        '_',
                        pin.Metadata.ppms_caresiteaddresslongitude,
                        '_',
                        encodeURIComponent(pin.Metadata.ppms_providername),
                        '">Directions</a> <br/>' +
                        providers[p].drivingDistance, ' ', distanceUnits,
                    '</td>');
                listItems
                    .push('<td>' + providers[p].ppms_specialtynametext + '</td>');
                
            }

            listItems.push('</tr>');
            listItems.push('</tbody>');
            listItems.push('</table>');

            //var clusterLayer = new Microsoft.Maps.ClusterLayer(pins, { gridSize: 100 });
            //clusterLayer.add(pins);
            //map.layers.insert(clusterLayer);

            var pinlayer = new Microsoft.Maps.Layer();
            pinlayer.add(pins);
            map.layers.insert(pinlayer);

            // Use the array of locations from the results to set the map view to show all locations.
            if (locs.length > 1) {
                map
                    .setView({
                        bounds: Microsoft.Maps.LocationRect.fromLocations(locs),
                        padding: 80
                    });
            } else {
                map.setView({ center: locs[0], zoom: 15 });
            }

            // Add the list items to the results panel.
            $('.resultsPanel').html(listItems.join(''));

            // Add a click event to the title of each list item.
            $('.title').click(function () {
                // Get the ID of the selected location
                var id = $(this).attr('rel');
                //Loop through all the pins in the data layer and find the pushpin for the location.
                var pin;
                for (var i = 0; i < pins.length; i++) {
                    pin = pins[i];
                    if (pin.Metadata.ppms_providerserviceid != id) {
                        pin = null;
                    } else {
                        break;
                    }
                }
                // If a pin is found with a matching ID, then center the map on it and show it's infobox.
                if (pin) {
                    // Offset the centering to account for the infobox.
                    map.setView({
                        center: pin.getLocation(),
                        centerOffset: new Microsoft.Maps.Point(-70, 150),
                        zoom: 17
                    });
                    displayInfobox(pin);
                }
            });
            $('.viewprofile').click(function () {
                // Get the ID of the selected Provider
                var id = $(this).attr('rel');
                var windowOptions = {
                    openInNewWindow: true
                };
                Xrm.Utility.openEntityForm("account", id, null, windowOptions)
            });
        }

        // Takes a pushpin and generates the content for the infobox from the Metadata and displays the infobox.
        function displayInfobox(pin) {

            var veteranLocation = $('#searchBox').val();

            infobox.setLocation(pin.getLocation());

            var desc = ['<table>'];

            desc.push('<tr><td colspan="2">', pin.Metadata.ppms_caresiteaddress, '<br/>', pin.Metadata.ppms_caresitecity, ', ');
            desc.push(pin.Metadata.ppms_caresitecity, '<br/>', pin.Metadata.ppms_caresitezipcode, '</td></tr>');
            desc.push('<tr><td><b>Hours:</b></td><td>',
                //pin.Metadata.hours,
                '</td></tr>');
            desc.push('<tr><td><b>Provider Specialty:</b></td><td>',
                pin.Metadata.ppms_specialtynametext,
                //pin.Metadata.name,
                '</td></tr>');
            //desc.push('<tr><td colspan="2"><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=~pos.', pin.Metadata.Latitude, '_', pin.Metadata.Longitude, '_', encodeURIComponent(pin.Metadata.ProviderName), '">Directions</a></td></tr>');
            desc.push('<tr><td colspan="2"><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                veteranLocation,
                '~pos.',
                pin.Metadata.ppms_caresiteaddresslatitude,
                '_',
                pin.Metadata.ppms_caresiteaddresslongitude,
                '_',
                encodeURIComponent(pin.Metadata.ppms_providername),
                '">Directions</a></td></tr>');
            desc.push('</table>');
            
            infobox.setOptions({ visible: true, title: pin.Metadata.ppms_providername, description: desc.join('') });
        }
    }
});